/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile;

import com.elluminate.groupware.profile.DefaultProfileItemFactory;
import com.elluminate.groupware.profile.Profile;
import com.elluminate.groupware.profile.ProfileItem;
import com.elluminate.groupware.profile.ProfileItemFactory;
import com.elluminate.groupware.profile.ProfileItemID;
import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.NotableEventListener;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ProfileProtocol
extends JinxProtocolAdapter {
    public static final String CHANNEL = "profile";
    public static final byte PRIORITY = 4;
    public static final String PROPERTY = "profile.distribution";
    public static final DebugFlag DEBUG = DebugFlag.get((String)"profile");
    public static final byte MODE_NONE = 0;
    public static final byte MODE_MODERATORS = 1;
    public static final byte MODE_ALL = 3;
    public static final byte MODE_INVALID = 127;
    public static final byte MODE_COUNT = 3;
    public static final byte PROFILE = 1;
    public static final byte IMAGE_REQUEST = 2;
    public static final byte IMAGE_DATA = 3;
    private static ProfileItemFactory factory = new DefaultProfileItemFactory();

    public ProfileProtocol() {
        this.defineChannel(CHANNEL, (byte)4);
        this.defineProperty(PROPERTY, (byte)1, Bytes.get((byte)3));
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 1: {
                return CHANNEL;
            }
            case 2: {
                return "imageRequest";
            }
            case 3: {
                return "imageData";
            }
        }
        return "***** UNKNOWN PROFILE MESSAGE " + cmd + " *****";
    }

    public String messageToString(byte cmd, DataInputStream istr) {
        StringBuffer buf = new StringBuffer(this.commandToString(cmd));
        buf.append(" - ");
        try {
            switch (cmd) {
                case 1: {
                    short addr = istr.readShort();
                    Profile profile = new Profile(istr);
                    buf.append(addr);
                    buf.append(" [");
                    buf.append(profile);
                    buf.append("]");
                    buf.append("]");
                    break;
                }
                case 2: {
                    short addr = istr.readShort();
                    ProfileItemID id = ProfileItemID.read(istr);
                    buf.append(id);
                    buf.append("(");
                    buf.append(addr);
                    buf.append(")");
                    break;
                }
                case 3: {
                    short addr = istr.readShort();
                    ProfileItem item = factory.getInstance(istr);
                    if (item != null) {
                        buf.append(item);
                        break;
                    }
                    buf.append("***** Invalid profile item *****");
                }
            }
        }
        catch (IOException iox) {
            buf.append("*** exception - " + iox + " ***");
        }
        return buf.toString();
    }

    public ProtocolResponder getResponder() {
        return new ProfileResponder();
    }

    public class ProfileResponder
    implements ProtocolResponder,
    ChannelDataListener {
        Channel chnl = null;

        public void join(Connection connection, String channelName) {
            try {
                this.chnl = connection.acquireChannel(channelName, (byte)4, null, (ChannelDataListener)this);
            }
            catch (JinxChannelException jcx) {
                LogSupport.exception((Object)this, (String)"join", (Throwable)jcx, (boolean)true);
            }
        }

        public void leave(String channelName) {
            this.chnl.getConnection().releaseChannel(this.chnl);
        }

        public void addNotableEventListener(NotableEventListener l) {
        }

        public void removeNotableEventListener(NotableEventListener l) {
        }

        public void onChannelData(ChannelDataEvent e) {
            if (e.getCommand() == 1) {
                try {
                    DataInputStream istr = e.read();
                    short addr = istr.readShort();
                    Profile profile = new Profile(istr);
                    for (ProfileItemID id : profile) {
                        if (profile.getMimeType(id) != "image/proxy") continue;
                        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)2);
                        try {
                            DataOutputStream ostr = cde.write();
                            ostr.writeShort(addr);
                            id.send(ostr);
                            ostr.close();
                            this.chnl.onChannelData(cde);
                        }
                        catch (IOException iox) {
                            LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)iox, (boolean)true);
                        }
                    }
                    istr.close();
                }
                catch (IOException iox) {
                    LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)iox, (boolean)true);
                }
            }
        }
    }
}

