/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile;

import com.elluminate.groupware.profile.DefaultProfileItemFactory;
import com.elluminate.groupware.profile.ProfileItem;
import com.elluminate.groupware.profile.ProfileItemFactory;
import com.elluminate.groupware.profile.ProfileItemID;
import com.elluminate.groupware.profile.StringsProperties;
import com.elluminate.groupware.profile.VCardItemID;
import com.elluminate.platform.Platform;
import com.elluminate.util.Base64;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.crypto.Hex;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.UIManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Profile
implements Iterable<ProfileItemID> {
    public static final String ENC_ASCII = "ASCII7";
    public static final int IMAGE_QUALITY = 70;
    private static final int HTML_BODY_PADDING_TOPBOTTOM = 8;
    private static final int HTML_TABLE_CELLPADDING_TOPBOTTOM = 5;
    private static final I18n i18n = I18n.create(Profile.class);
    private static ProfileItemFactory factory = new DefaultProfileItemFactory();
    private Map<ProfileItemID, ProfileItem> data = new TreeMap<ProfileItemID, ProfileItem>(new ProfileItemID.ItemIDComparator());
    private int changeClock = 1;
    private String html = null;
    private String href = null;

    public Profile(DataInputStream istr) throws IOException {
        ProfileItem item;
        do {
            if ((item = factory.getInstance(istr)) == null) continue;
            this.data.put(item.getID(), item);
        } while (item != null);
        ++this.changeClock;
        this.html = null;
    }

    public Profile(File f) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(f);
        Element root = doc.getRootElement();
        if (!root.getName().equals("profile")) {
            throw new JDOMException("Root element is not <profile>");
        }
        for (Element e : root.getChildren()) {
            ProfileItem item = factory.getInstance(e);
            if (item == null) continue;
            this.data.put(item.getID(), item);
        }
        ++this.changeClock;
        this.html = null;
    }

    public Profile(URL u) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(u);
        Element root = doc.getRootElement();
        if (!root.getName().equals("profile")) {
            throw new JDOMException("Root element is not <profile>");
        }
        for (Element e : root.getChildren()) {
            ProfileItem item = factory.getInstance(e);
            if (item == null) continue;
            this.data.put(item.getID(), item);
        }
        ++this.changeClock;
        this.html = null;
    }

    public Profile(Profile orig) {
        for (ProfileItemID id : orig.data.keySet()) {
            ProfileItem pi = orig.data.get(id);
            this.set(pi);
        }
    }

    public Profile() {
    }

    public int getChangeClock() {
        return this.changeClock;
    }

    public void setChangeClock(int cc) {
        this.changeClock = cc;
        this.html = null;
    }

    private ProfileItem getItem(ProfileItemID id) {
        return this.data.get(id);
    }

    public String getMimeType(ProfileItemID id) {
        ProfileItem item = this.getItem(id);
        if (item == null) {
            return null;
        }
        return item.getMime();
    }

    public String getHTML(String useHref, String jinxName) {
        if (this.html != null && (useHref == this.href || useHref.equals(this.href))) {
            return this.html;
        }
        this.href = useHref;
        this.html = this.makeHTML(jinxName);
        return this.html;
    }

    public int getHtmlMinimumHeight() {
        int height = 26;
        if (this.contains(ProfileItemID.PHOTO)) {
            height += this.getHeight(ProfileItemID.PHOTO);
        }
        return height;
    }

    private static String color2html(Color color) {
        StringBuilder b = new StringBuilder();
        b.append("#");
        String v = Integer.toHexString(color.getRed());
        if (v.length() == 1) {
            b.append('0');
        }
        b.append(v);
        v = Integer.toHexString(color.getGreen());
        if (v.length() == 1) {
            b.append('0');
        }
        b.append(v);
        v = Integer.toHexString(color.getBlue());
        if (v.length() == 1) {
            b.append('0');
        }
        b.append(v);
        return b.toString();
    }

    private String makeHTML(String jinxName) {
        if (this.data.isEmpty()) {
            return null;
        }
        Font f = UIManager.getFont("Label.font");
        Color bg = Color.WHITE;
        UIManager.getColor("ToolTip.background");
        Color fg = UIManager.getColor("ToolTip.foreground");
        StringBuffer html = new StringBuffer();
        html.append("<html>\n");
        html.append("  <head>");
        html.append("  <style>\n");
        html.append("  body { color: " + Profile.color2html(fg) + ";\n");
        html.append("  background-color: " + Profile.color2html(bg) + ";\n");
        html.append("  font-family: " + f.getFamily() + ", sans-serif;\n");
        html.append("  font-size: " + f.getSize() + "pt;\n");
        html.append("  margin: 0;\n");
        html.append("  padding: 4px 8px;}\n");
        html.append("  </style>\n");
        html.append("  </head>\n");
        html.append("  <body>\n");
        if (this.href != null && this.contains(ProfileItemID.PHOTO)) {
            html.append("    <table cellpadding=5 cellspacing=0>\n");
            html.append("      <tr><td width=");
            html.append(this.getWidth(ProfileItemID.PHOTO));
            html.append("><img src=\"");
            html.append(this.href);
            html.append("/photo/");
            html.append(this.changeClock);
            html.append("\"></td><td width=320>");
        }
        html.append("        <table width=320 cellpadding=1 cellspacing=0>\n");
        if (this.contains(ProfileItemID.FULL_NAME)) {
            this.insertHtml(ProfileItemID.FULL_NAME, html);
        } else if (this.contains(ProfileItemID.FIRST_NAME)) {
            if (this.contains(ProfileItemID.LAST_NAME)) {
                String label = ProfileItemID.FULL_NAME.getLabel();
                String nm = this.getString(ProfileItemID.FIRST_NAME) + " " + this.getString(ProfileItemID.LAST_NAME);
                this.insertHtml(label, nm, html);
            } else {
                this.insertHtml(ProfileItemID.FIRST_NAME, html);
            }
        } else if (this.contains(ProfileItemID.LAST_NAME)) {
            this.insertHtml(ProfileItemID.LAST_NAME, html);
        } else if (jinxName != null) {
            String label = ProfileItemID.FULL_NAME.getLabel();
            this.insertHtml(label, jinxName, html);
        }
        this.insertHtml(ProfileItemID.TITLE, html);
        this.insertHtml(ProfileItemID.COMPANY, html);
        this.insertHtml(ProfileItemID.HOME_PHONE, html);
        this.insertHtml(ProfileItemID.WORK_PHONE, html);
        this.insertHtml(ProfileItemID.CELL_PHONE, html);
        this.insertHtml(ProfileItemID.HOME_EMAIL, html);
        this.insertHtml(ProfileItemID.WORK_EMAIL, html);
        this.insertHtmlAddr("address.home", html);
        this.insertHtmlAddr("address.work", html);
        html.append("        </table>\n");
        if (this.contains(ProfileItemID.PHOTO)) {
            html.append("      </td></tr>\n");
            html.append("    </table>\n");
        }
        html.append("  </body>\n");
        html.append("</html>\n");
        return html.toString();
    }

    private void insertHtml(ProfileItemID id, StringBuffer html) {
        if (this.contains(id)) {
            String value = this.getString(id);
            String label = id.getLabel();
            this.insertHtml(label, value, html);
        }
    }

    private void insertHtml(String label, String value, StringBuffer html) {
        html.append("          <tr><td width=120 align=right valign=top>");
        html.append(this.escape(label));
        html.append(":");
        html.append("</td><td>");
        html.append(this.escape(value));
        html.append("</td></tr>\n");
    }

    private String getAddressPart(String nm) {
        ProfileItemID id = ProfileItemID.get(nm);
        if (this.contains(id)) {
            return this.getString(id);
        }
        return null;
    }

    private void insertHtmlAddr(String base, StringBuffer html) {
        String[] addressParts = new String[]{this.getAddressPart(base + ".street"), this.getAddressPart(base + ".locality"), this.getAddressPart(base + ".region"), this.getAddressPart(base + ".postal"), this.getAddressPart(base + ".country")};
        String formattedAddress = this.getFormattedAddress(i18n.getString((PropertiesEnum)StringsProperties.PROFILE_ADDRESSFORMAT), addressParts);
        if (formattedAddress.length() > 0) {
            this.insertHtml(i18n.getStringLegacy("ProfileItemID." + base), formattedAddress, html);
        }
    }

    private String getFormattedAddress(String addressFormat, String[] addressParts) {
        String finalFormat = "";
        int varStart = addressFormat.indexOf(123);
        int varEnd = addressFormat.indexOf(125);
        String prefix = addressFormat.substring(0, varStart);
        String suffix = "";
        while (varStart > -1 && varEnd > -1) {
            suffix = "";
            int nextVarStart = addressFormat.indexOf(123, varEnd);
            String variable = addressFormat.substring(varStart + 1, varEnd);
            int varIndex = 0;
            varIndex = variable.indexOf(44) > -1 ? Integer.parseInt(variable.substring(0, variable.indexOf(44)).trim()) : Integer.parseInt(variable.trim());
            if (nextVarStart > -1) {
                suffix = addressFormat.substring(varEnd + 1, nextVarStart);
                addressFormat = addressFormat.substring(nextVarStart);
            } else {
                suffix = addressFormat.substring(varEnd + 1);
                addressFormat = "";
            }
            if (addressParts[varIndex] != null && addressParts[varIndex].length() > 0) {
                finalFormat = finalFormat + prefix + "{" + variable + "}";
                prefix = suffix;
            } else if (suffix.indexOf(10) > -1) {
                prefix = suffix;
            }
            varStart = addressFormat.indexOf(123);
            varEnd = addressFormat.indexOf(125);
        }
        finalFormat = finalFormat + suffix;
        return MessageFormat.format(finalFormat, addressParts).trim();
    }

    private String escape(String src) {
        StringBuffer buf = new StringBuffer();
        boolean empty = true;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c == '<' || c == '>' || c == '\n') {
                if (empty) {
                    buf.append(src.substring(0, i));
                    empty = false;
                }
                if (c == '<') {
                    buf.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    buf.append("&gt;");
                    continue;
                }
                if (c != '\n') continue;
                buf.append("<br>");
                continue;
            }
            if (empty) continue;
            buf.append(c);
        }
        if (!empty) {
            src = buf.toString();
        }
        return src;
    }

    public byte[] getRaw(ProfileItemID id) {
        ProfileItem item = this.getItem(id);
        if (item == null) {
            return null;
        }
        return item.getRaw();
    }

    public String getString(ProfileItemID id) {
        ProfileItem item = this.getItem(id);
        if (item == null) {
            return null;
        }
        return item.getText();
    }

    public String getString(ProfileItemID id, String dft) {
        ProfileItem item = this.getItem(id);
        if (item == null) {
            return dft;
        }
        return item.getText();
    }

    public Image getImage(ProfileItemID id) {
        ProfileItem item = this.getItem(id);
        if (item == null) {
            return null;
        }
        return item.getImage();
    }

    public int getWidth(ProfileItemID id) {
        ProfileItem item = this.getItem(id);
        if (item == null) {
            return 0;
        }
        return item.getWidth();
    }

    public int getHeight(ProfileItemID id) {
        ProfileItem item = this.getItem(id);
        if (item == null) {
            return 0;
        }
        return item.getHeight();
    }

    public void set(ProfileItemID id, String value) {
        if (value == null) {
            this.data.remove(id);
        } else if (value.equals("")) {
            this.data.remove(id);
        } else {
            if (value.length() > 64) {
                value = value.substring(0, 64);
            }
            ProfileItem item = factory.getInstance(id, value);
            this.data.put(id, item);
        }
        ++this.changeClock;
        this.html = null;
    }

    public void set(ProfileItemID id, Image icon) {
        if (icon == null || ImageSupport.encodeAsJPEG((Image)icon, (int)70) == null) {
            this.data.remove(id);
        } else {
            ProfileItem item = factory.getInstance(id, icon);
            this.data.put(id, item);
        }
        ++this.changeClock;
        this.html = null;
    }

    public void set(ProfileItem item) {
        this.data.put(item.getID(), item);
        ++this.changeClock;
        this.html = null;
    }

    public void remove(ProfileItemID id) {
        this.data.remove(id);
        ++this.changeClock;
        this.html = null;
    }

    public void clear() {
        this.data.clear();
        ++this.changeClock;
        this.html = null;
    }

    public boolean contains(String nm) {
        return this.contains(ProfileItemID.get(nm));
    }

    public boolean contains(ProfileItemID id) {
        return this.data.containsKey(id);
    }

    public void send(DataOutputStream ostr) throws IOException {
        for (ProfileItem item : this.data.values()) {
            item.send(ostr);
        }
        ostr.writeByte(0);
    }

    public void sendDeferred(DataOutputStream ostr) throws IOException {
        for (ProfileItem item : this.data.values()) {
            item.sendDeferred(ostr);
        }
        ostr.writeByte(0);
    }

    public void sendItem(ProfileItemID id, DataOutputStream ostr) throws IOException {
        ProfileItem item = this.getItem(id);
        if (item != null) {
            item.send(ostr);
        }
    }

    public void save(File f) throws IOException {
        Element root = new Element("profile");
        Document doc = new Document(root);
        for (ProfileItem item : this.data.values()) {
            item.write(root);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        out.output(doc, (Writer)writer);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public boolean isAscii() {
        for (ProfileItem item : this.data.values()) {
            String txt = item.getText();
            if (txt == null) continue;
            for (int idx = 0; idx < txt.length(); ++idx) {
                if (txt.charAt(idx) <= '\u007f') continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<ProfileItemID> iterator() {
        return this.data.keySet().iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (ProfileItem item : this.data.values()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(item);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        Profile p = (Profile)o;
        if (p.data.size() != this.data.size()) {
            return false;
        }
        for (ProfileItemID key : this) {
            ProfileItem p2;
            ProfileItem p1 = this.getItem(key);
            if (p1.equals(p2 = p.getItem(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = 337983047;
        for (ProfileItem item : this.data.values()) {
            code ^= item.hashCode();
        }
        return code;
    }

    public void exportVCard(File f) throws IOException {
        this.exportVCard(f, "UTF-8");
    }

    public void exportVCard(File f, String encoding) throws IOException {
        FileWriter fw = new FileWriter(f);
        PrintWriter print = new PrintWriter(fw);
        this.exportVCard(print, encoding);
        print.close();
    }

    public void exportVCard(PrintWriter out) {
        this.exportVCard(out, "UTF-8");
    }

    public void exportVCard(PrintWriter out, String enc) {
        out.print("BEGIN:VCARD\r\n");
        out.print("VERSION:2.1\r\n");
        if (this.data.containsKey(ProfileItemID.FIRST_NAME) || this.data.containsKey(ProfileItemID.LAST_NAME)) {
            String f = this.getString(ProfileItemID.FIRST_NAME, "");
            String l = this.getString(ProfileItemID.LAST_NAME, "");
            String[] values = new String[]{l, f, "", "", ""};
            out.print(this.encode("N", values, enc));
        }
        this.exportItem(ProfileItemID.FULL_NAME, "FN", out, enc);
        this.exportItem(ProfileItemID.TITLE, "TITLE", out, enc);
        if (this.contains(ProfileItemID.COMPANY)) {
            String[] values = new String[]{this.getString(ProfileItemID.COMPANY), ""};
            out.print(this.encode("ORG", values, enc));
        }
        this.exportItem(ProfileItemID.HOME_PHONE, "TEL;HOME;VOICE", out, enc);
        this.exportItem(ProfileItemID.WORK_PHONE, "TEL;WORK;VOICE", out, enc);
        this.exportItem(ProfileItemID.CELL_PHONE, "TEL;CELL;VOICE", out, enc);
        this.exportAddress("address.home", "ADR;HOME;POSTAL;PARCEL;INTL", out, enc);
        this.exportAddress("address.work", "ADR;WORK;POSTAL;PARCEL;INTL", out, enc);
        this.exportItem(ProfileItemID.URL, "URL", out, enc);
        this.exportItem(ProfileItemID.WORK_EMAIL, "EMAIL;WORK;INTERNET", out, enc);
        this.exportItem(ProfileItemID.HOME_EMAIL, "EMAIL;HOME;INTERNET", out, enc);
        if (this.data.containsKey(ProfileItemID.PHOTO)) {
            StringBuffer b64 = new StringBuffer();
            out.println("PHOTO;TYPE=JPEG;ENCODING=BASE64:");
            Base64.encode((byte[])this.getRaw(ProfileItemID.PHOTO), (StringBuffer)b64);
            String str64 = b64.toString();
            int len = str64.length();
            for (int i = 0; i < len; i += 72) {
                int n = Math.min(len, i + 72);
                out.print(" " + str64.substring(i, n) + "\r\n");
            }
        }
        out.print("END:VCARD\r\n");
    }

    public void importVCard(File f) throws IOException {
        FileReader fr = new FileReader(f);
        BufferedReader r = new BufferedReader(fr);
        this.importVCard(r);
        r.close();
    }

    public void importVCard(BufferedReader r) throws IOException {
        PushbackReader pr = new PushbackReader(r);
        this.clear();
        try {
            VCardLine line;
            boolean begin = false;
            while ((line = this.readLine(pr)) != null) {
                String loc = line.name.getLocation();
                if (loc != null && loc.equalsIgnoreCase("URL")) continue;
                if (!begin) {
                    if (line.name.getID() != 28) continue;
                    begin = true;
                    continue;
                }
                switch (line.name.getID()) {
                    case 29: {
                        throw new EOFException();
                    }
                    case 1: {
                        this.setText(ProfileItemID.FULL_NAME, line);
                        break;
                    }
                    case 0: {
                        String[] values = this.getText(line);
                        if (values == null) break;
                        if (values.length > 0) {
                            this.set(ProfileItemID.LAST_NAME, values[0]);
                        }
                        if (values.length <= 1) break;
                        this.set(ProfileItemID.FIRST_NAME, values[1]);
                        break;
                    }
                    case 4: {
                        String[] values = this.getText(line);
                        if (line.name.checkType("home", false)) {
                            this.setAddress("address.home", values);
                        }
                        if (!line.name.checkType("work", true)) break;
                        this.setAddress("address.work", values);
                        break;
                    }
                    case 5: {
                        if (line.name.checkType("home", false)) {
                            this.setText(ProfileItemID.HOME_PHONE, line);
                        }
                        if (line.name.checkType("work", false)) {
                            this.setText(ProfileItemID.WORK_PHONE, line);
                        }
                        if (!line.name.checkType("cell", false)) break;
                        this.setText(ProfileItemID.CELL_PHONE, line);
                        break;
                    }
                    case 6: {
                        if (line.name.checkType("home", false)) {
                            this.setText(ProfileItemID.HOME_EMAIL, line);
                            break;
                        }
                        if (line.name.checkType("work", false)) {
                            this.setText(ProfileItemID.WORK_EMAIL, line);
                            break;
                        }
                        if (!line.name.checkType("internet", true)) break;
                        this.setText(ProfileItemID.WORK_EMAIL, line);
                        break;
                    }
                    case 10: {
                        String[] values = this.getText(line);
                        if (values == null || values.length <= 0) break;
                        this.set(ProfileItemID.COMPANY, values[0]);
                        break;
                    }
                    case 3: {
                        this.setImage(ProfileItemID.PHOTO, line);
                        break;
                    }
                    case 7: {
                        this.setText(ProfileItemID.TITLE, line);
                        break;
                    }
                    case 13: {
                        this.setText(ProfileItemID.URL, line);
                    }
                }
            }
        }
        catch (EOFException eof) {
        }
        catch (IOException iox) {
            LogSupport.error((Object)this, (String)"importVCard", (String)("Exception reading vCard: " + iox.toString()));
        }
    }

    private String encode(String nm, String[] values, String enc) {
        boolean encoding = false;
        boolean charset = false;
        boolean done = false;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < values.length && !done; ++i) {
            for (int c = 0; c < values[i].length() && !done; ++c) {
                char chr = values[i].charAt(c);
                if (chr < '\t' || chr > '\t' && chr < ' ') {
                    encoding = true;
                    continue;
                }
                if (chr <= '\u007f') continue;
                encoding = true;
                charset = true;
                done = true;
            }
        }
        buf.append(nm);
        if (encoding) {
            buf.append(";ENCODING=QUOTED-PRINTABLE");
        }
        if (charset) {
            buf.append(";CHARSET=");
            buf.append(enc);
        }
        buf.append(':');
        int lineLen = buf.length();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                buf.append(';');
                ++lineLen;
            }
            lineLen = this.encode1(values[i], charset, encoding, lineLen, buf, enc);
        }
        buf.append("\r\n");
        return buf.toString();
    }

    private String encode(String nm, String value, String enc) {
        String[] values = new String[]{value};
        return this.encode(nm, values, enc);
    }

    private int encode1(String value, boolean charset, boolean encode, int lineLen, StringBuffer buf, String enc) {
        byte[] data = null;
        try {
            data = value.getBytes(charset ? enc : ENC_ASCII);
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"encode1", (Throwable)t, (boolean)true);
            return lineLen;
        }
        for (int i = 0; i < data.length; ++i) {
            int val = data[i] & 0xFF;
            if (val == 59) {
                lineLen += 2;
                buf.append("\\;");
                continue;
            }
            if (encode) {
                if (val == 10) {
                    buf.append("=0D=0A");
                    lineLen += 6;
                    continue;
                }
                if ((val == 32 || val == 9) && lineLen > 64) {
                    buf.append("=\r\n");
                    buf.append((char)val);
                    lineLen = 1;
                    continue;
                }
                if (val == 9 || val >= 32 && val < 61 || val > 61 && val <= 127) {
                    buf.append((char)val);
                    ++lineLen;
                    continue;
                }
                buf.append('=');
                buf.append(Hex.toString((byte)data[i]));
                lineLen += 3;
                continue;
            }
            ++lineLen;
            buf.append((char)val);
        }
        return lineLen;
    }

    private void exportItem(ProfileItemID id, String nm, PrintWriter out, String encoding) {
        if (this.data.containsKey(id)) {
            out.print(this.encode(nm, this.getString(id), encoding));
        }
    }

    private void exportAddress(String base, String nm, PrintWriter out, String enc) {
        String[] values = new String[]{"", "", this.getString(ProfileItemID.get(base + ".street"), ""), this.getString(ProfileItemID.get(base + ".locality"), ""), this.getString(ProfileItemID.get(base + ".region"), ""), this.getString(ProfileItemID.get(base + ".postal"), ""), this.getString(ProfileItemID.get(base + ".country"), "")};
        for (int i = 0; i < values.length; ++i) {
            if (values[i].length() <= 0) continue;
            out.print(this.encode(nm, values, enc));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private VCardLine readLine(PushbackReader r) throws IOException {
        StringBuffer buf = new StringBuffer();
        VCardItemID id = null;
        String value = null;
        byte[] data = null;
        int encoding = 0;
        boolean haveEOL = false;
        boolean haveEquals = false;
        int c = r.read();
        while (c >= 0) {
            block19: {
                block21: {
                    block22: {
                        block20: {
                            if (id != null) break block20;
                            if ((char)c == ':') {
                                id = new VCardItemID(buf.toString());
                                buf = new StringBuffer();
                                encoding = id.getEncodingID();
                                break block19;
                            } else {
                                buf.append((char)c);
                            }
                            break block19;
                        }
                        if (c == 13) break block19;
                        if (encoding != 3) break block21;
                        if (c != 61) break block22;
                        haveEquals = true;
                        break block19;
                    }
                    if (c == 10) {
                        if (haveEquals) {
                            haveEquals = false;
                        }
                        haveEOL = true;
                        break block19;
                    } else {
                        if (haveEOL) {
                            if (c == 32 || c == 9) {
                                haveEOL = false;
                                buf.append((char)c);
                                break block19;
                            } else {
                                r.unread(c);
                                break;
                            }
                        }
                        if (haveEquals) {
                            buf.append('=');
                            haveEquals = false;
                        }
                        buf.append((char)c);
                    }
                    break block19;
                }
                if (haveEOL) {
                    if (c == 32 || c == 9) {
                        haveEOL = false;
                        buf.append((char)c);
                    } else {
                        r.unread(c);
                        break;
                    }
                }
                if (c == 10) {
                    haveEOL = true;
                } else {
                    buf.append((char)c);
                }
            }
            c = r.read();
        }
        value = buf.toString();
        switch (encoding) {
            case 2: {
                data = Base64.decode((String)value);
                return new VCardLine(id, data);
            }
            case 3: {
                data = this.qpDecode(value);
                return new VCardLine(id, data);
            }
        }
        String enc = System.getProperty("file.encoding", ENC_ASCII);
        data = value.getBytes(enc);
        return new VCardLine(id, data);
    }

    private byte[] qpDecode(String value) {
        byte[] buffer = new byte[value.length()];
        int off = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '=') {
                try {
                    int h1 = Character.digit(value.charAt(i + 1), 16);
                    int h2 = Character.digit(value.charAt(i + 2), 16);
                    if (h1 < 0 || h2 < 0) {
                        buffer[off++] = 61;
                        continue;
                    }
                    buffer[off++] = (byte)(h1 << 4 | h2);
                    i += 2;
                }
                catch (Throwable t) {
                    buffer[off++] = 61;
                }
                continue;
            }
            buffer[off++] = (byte)c;
        }
        if (off < buffer.length) {
            byte[] sub = new byte[off];
            System.arraycopy(buffer, 0, sub, 0, off);
            buffer = sub;
        }
        return buffer;
    }

    private void setImage(ProfileItemID id, VCardLine line) {
        try {
            String[] type = line.name.getType();
            String mime = null;
            for (int i = 0; i < type.length; ++i) {
                String m = Platform.getMimeType((String)("foo." + type[i].toLowerCase(Locale.ENGLISH)));
                if (m == null) continue;
                mime = m;
                break;
            }
            if (mime != null) {
                this.set(factory.getInstance(id, line.data, mime));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setText(ProfileItemID id, VCardLine line) {
        String charset = line.name.getCharset();
        try {
            String value = new String(line.data, charset);
            this.set(id, value);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private void setAddress(String root, String[] values) {
        if (values != null) {
            if (values.length > 2) {
                this.set(ProfileItemID.get(root + ".street"), values[2]);
            }
            if (values.length > 3) {
                this.set(ProfileItemID.get(root + ".locality"), values[3]);
            }
            if (values.length > 4) {
                this.set(ProfileItemID.get(root + ".region"), values[4]);
            }
            if (values.length > 5) {
                this.set(ProfileItemID.get(root + ".postal"), values[5]);
            }
            if (values.length > 6) {
                this.set(ProfileItemID.get(root + ".country"), values[6]);
            }
        }
    }

    private String[] getText(VCardLine line) {
        String value;
        String charset = line.name.getCharset();
        try {
            value = new String(line.data, charset);
        }
        catch (UnsupportedEncodingException uex) {
            return null;
        }
        try {
            LinkedList<String> list = new LinkedList<String>();
            StringBuffer part = new StringBuffer();
            boolean esc = false;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (esc) {
                    part.append(c);
                    esc = false;
                    continue;
                }
                if (c == '\\') {
                    esc = true;
                    continue;
                }
                if (c == ';') {
                    list.add(part.toString());
                    part.setLength(0);
                    continue;
                }
                part.append(c);
            }
            list.add(part.toString());
            return list.toArray(new String[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void setProfileItemFactory(ProfileItemFactory f) {
        factory = f;
    }

    class VCardLine {
        public VCardItemID name;
        public byte[] data;

        public VCardLine(VCardItemID id, byte[] val) {
            this.name = id;
            this.data = val;
        }
    }
}

