/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Connector;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.JinxProtocolException;
import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.PacketEvent;
import com.elluminate.jinx.PacketHistory;
import com.elluminate.jinx.PacketListener;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.ReassemblyData;
import com.elluminate.jinx.Transceiver;
import com.elluminate.jinx.TransceiverEvent;
import com.elluminate.jinx.TransceiverListener;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.util.Debug;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TooManyListenersException;

public class NetworkConnector
extends Connector {
    public static final int HEADER_LENGTH = 5;
    private int segmentationThreshold = 500;
    private Transceiver transceiver = null;
    private Map<Short, ReassemblyData[]> reassembly = new HashMap<Short, ReassemblyData[]>();
    private PacketHandler handler = new PacketHandler();
    private int[] messageID = new int[5];
    private boolean first = true;
    private long connectedAt = -1L;
    private Object transmitLock = new Object();
    private PacketHistory history = new PacketHistory(128);

    public NetworkConnector() {
        int i = 0;
        while (i < 5) {
            this.messageID[i++] = 1;
        }
    }

    @Override
    public void disconnect() {
        if (this.transceiver != null) {
            this.transceiver.disconnect((byte)1);
        }
    }

    public void setTransceiver(Transceiver tx) {
        if (this.transceiver != null) {
            this.transceiver.removePacketListener(this.handler);
            this.transceiver.removeTransceiverListener(this.handler);
        }
        this.transceiver = tx;
        if (this.transceiver != null) {
            try {
                this.transceiver.addPacketListener(this.handler);
            }
            catch (TooManyListenersException ex) {
                LogSupport.exception((Object)this, (String)"setTransceiver", (Throwable)ex, (boolean)true);
                return;
            }
            this.transceiver.addTransceiverListener(this.handler);
        }
    }

    public Transceiver getTransceiver() {
        return this.transceiver;
    }

    @Override
    public short getAddress() {
        if (this.transceiver == null) {
            return -32767;
        }
        return this.transceiver.getAddress();
    }

    @Override
    public short getGroupID() {
        if (this.transceiver == null) {
            return -32767;
        }
        return this.transceiver.getGroup();
    }

    @Override
    public void setGroupID(short id) {
        this.transceiver.setGroup(id);
    }

    @Override
    public String getName() {
        if (this.transceiver == null) {
            return null;
        }
        return this.transceiver.getName();
    }

    @Override
    public long getConnectedMillis() {
        if (this.connectedAt < 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.connectedAt;
    }

    @Override
    public boolean isEnabled() {
        if (this.transceiver == null) {
            return false;
        }
        return this.transceiver.isEnabled();
    }

    @Override
    public int getMaxXmitSpeed() {
        if (this.transceiver == null) {
            return 0;
        }
        return this.transceiver.getMaxXmitSpeed();
    }

    private void fireOnPacket(PacketEvent packet) {
        if (this.transceiver != null) {
            if (DebugFlags.PACKETS.show()) {
                LogSupport.message((Object)this, (String)"fireOnPacket", (String)("Xmit packet - " + packet.toString(true)));
            }
            try {
                this.transceiver.onPacket(packet);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireOnPacket", (Throwable)ex, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(MessageEvent message) {
        ProtocolBuffer payload = message.getContent();
        if (DebugFlags.MESSAGES.show()) {
            LogSupport.message((String)("Xmit chnl=" + message.getChannel() + ", to=" + message.getDestinationAddress() + ", size=" + payload.getSize() + ", cmd=" + message.getCommand()));
        }
        Debug.lockEnter((Object)this, (String)"onMessage", (String)"transmitLock", (Object)this.transmitLock);
        Object object = this.transmitLock;
        synchronized (object) {
            if (payload.getSize() < this.segmentationThreshold) {
                this.addSegmentHeader(payload, 0, message);
                this.fireOnPacket(message);
            } else {
                this.segment(message);
            }
        }
        Debug.lockLeave((Object)this, (String)"onMessage", (String)"transmitLock", (Object)this.transmitLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransmitStatus(TransmitStatusEvent event) {
        Debug.lockEnter((Object)this, (String)"transmitComplete", (String)"transmitLock", (Object)this.transmitLock);
        Object object = this.transmitLock;
        synchronized (object) {
            try {
                if (this.transceiver != null) {
                    this.transceiver.onTransmitStatus(event);
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"transmitComplete", (Throwable)ex, (boolean)true);
            }
        }
        Debug.lockLeave((Object)this, (String)"transmitComplete", (String)"transmitLock", (Object)this.transmitLock);
    }

    private void segment(MessageEvent msg) {
        ProtocolBuffer buf = msg.getContent();
        int nSegments = buf.getSegmentCount();
        if (DebugFlags.PACKETS.show()) {
            LogSupport.message((Object)this, (String)"segment", (String)("buf=" + buf));
        }
        for (int i = nSegments - 1; i >= 0; --i) {
            PacketEvent packet = PacketEvent.newInstance((Object)this, msg.getSourceAddress(), msg.getDestinationAddress(), msg.getGroupID(), msg.getPriority(), buf.getNextSegment());
            this.addSegmentHeader(packet.getContent(), i, msg);
            this.fireOnPacket(packet);
        }
        msg.dispose();
    }

    private void addSegmentHeader(ProtocolBuffer buf, int left, MessageEvent msg) {
        DataOutputStream str = buf.addHeader();
        byte pri = msg.getPriority();
        try {
            if (this.first) {
                str.writeByte(this.messageID[pri]);
                this.first = false;
            } else {
                str.writeByte(-this.messageID[pri]);
            }
            str.writeShort(left);
            str.writeByte(msg.getChannel());
            str.writeByte(msg.getCommand());
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"addSegmentHeader", (Throwable)ex, (boolean)true);
        }
        if (left == 0) {
            byte by = pri;
            this.messageID[by] = this.messageID[by] + 1;
            if (this.messageID[pri] > 127) {
                this.messageID[pri] = 1;
            }
            this.first = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void txOnPacket(PacketEvent packet) {
        byte cmd;
        byte chnl;
        short left;
        byte msgID;
        Short key = ShortList.get((short)packet.getSourceAddress());
        ReassemblyData[] rdSet = this.reassembly.get(key);
        ReassemblyData rd = null;
        ProtocolBuffer content = packet.getContent();
        byte pri = packet.getPriority();
        DataInputStream hdr = content.readHeader(5);
        try {
            msgID = hdr.readByte();
            left = hdr.readShort();
            chnl = hdr.readByte();
            cmd = hdr.readByte();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"onPacket", (Throwable)ex, (boolean)true);
            return;
        }
        finally {
            try {
                hdr.close();
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"onPacket", (Throwable)ex, (boolean)true);
            }
        }
        this.history.add(packet, msgID, left, chnl, cmd);
        if (rdSet != null) {
            rd = rdSet[pri];
        }
        if (rd != null) {
            try {
                rd.merge(packet, msgID, left);
                if (rd.isDone()) {
                    MessageEvent msg = rd.getMessage();
                    this.fireOnMessage(msg);
                    rd = null;
                    rdSet[pri] = null;
                }
                return;
            }
            catch (JinxProtocolException ex) {
                LogSupport.exception((Object)this, (String)"onPacket", (Throwable)ex, (boolean)false);
                this.history.dump();
                rd = null;
                rdSet[pri] = null;
            }
        } else if (msgID < 0) {
            if (this.transceiver.getAddress() == 0) {
                LogSupport.error((Object)this, (String)"txOnPacket", (String)"Missing message start packet.");
                this.history.dump();
            }
            return;
        }
        if (left == 0) {
            MessageEvent msg = MessageEvent.getInstance((Object)this, packet.getSourceAddress(), packet.getDestinationAddress(), packet.getGroupID(), packet.getPriority(), chnl, cmd, packet.removeContent());
            this.fireOnMessage(msg);
        } else {
            if (rdSet == null) {
                rdSet = new ReassemblyData[5];
                this.reassembly.put(key, rdSet);
            }
            rdSet[pri] = rd = new ReassemblyData(packet, msgID, left, chnl, cmd);
        }
    }

    protected void txTransmitComplete(TransmitStatusEvent event) {
        if (!event.isTransmitComplete()) {
            event.setTransmitComplete();
            this.transceiver.onTransmitStatus(event);
        } else {
            this.fireOnTranmitStatus(event);
        }
    }

    protected void txStatusChanged(TransceiverEvent event) {
        Transceiver tx = event.getTransceiver();
        switch (event.getAction()) {
            case 3: {
                this.reassembly.clear();
                this.connectedAt = -1L;
                break;
            }
            case 2: {
                this.connectedAt = System.currentTimeMillis();
            }
        }
        this.fireConnectionStatusChanged(tx.getAddress(), tx.getName(), event.getAction(), event.getPreviousState(), event.getReason(), tx);
    }

    class PacketHandler
    implements PacketListener,
    TransceiverListener {
        PacketHandler() {
        }

        @Override
        public void onPacket(PacketEvent packet) {
            if (DebugFlags.PACKETS.show()) {
                LogSupport.message((Object)this, (String)"onPacket", (String)("Recv packet - " + packet.toString(true)));
            }
            NetworkConnector.this.txOnPacket(packet);
        }

        @Override
        public void onTransmitStatus(TransmitStatusEvent event) {
            NetworkConnector.this.txTransmitComplete(event);
        }

        @Override
        public void transceiverStatusChanged(TransceiverEvent event) {
            NetworkConnector.this.txStatusChanged(event);
        }
    }
}

