/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.util.log.LogSupport;
import java.io.DataOutputStream;
import java.io.IOException;

public class ControlPacket {
    byte op;
    int[] args = null;

    public ControlPacket(byte op) {
        this.op = op;
        this.args = new int[0];
    }

    public ControlPacket(byte op, int arg) {
        this.op = op;
        this.args = new int[1];
        this.args[0] = arg;
    }

    public ControlPacket(byte op, int arg1, int arg2) {
        this.op = op;
        this.args = new int[2];
        this.args[0] = arg1;
        this.args[1] = arg2;
    }

    public byte getOp() {
        return this.op;
    }

    public int getArg(int idx) {
        return this.args[idx];
    }

    public int size() {
        return 10 + this.args.length * 4;
    }

    public ProtocolBuffer getBuffer(short from) {
        ProtocolBuffer buf = ProtocolBuffer.getInstance();
        DataOutputStream dataStream = buf.addPayload();
        try {
            dataStream.writeShort(from);
            dataStream.writeShort(-1);
            dataStream.writeShort(-1);
            dataStream.writeByte(0);
            dataStream.writeByte(this.op);
            dataStream.writeShort(this.args.length * 4);
            for (int i = 0; i < this.args.length; ++i) {
                dataStream.writeInt(this.args[i]);
            }
            dataStream.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"makeControlPacket", (Throwable)ex, (boolean)true);
            return null;
        }
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Control Packet ");
        buf.append(this.op);
        buf.append("(");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.args[i]);
        }
        buf.append(")");
        return buf.toString();
    }
}

