/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Channel;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.TooManyListenersException;

public class Client
extends Connection {
    @Override
    public Connection.Type getConnectionType() {
        return Connection.Type.GENERIC_CLIENT;
    }

    public boolean isPlayback() {
        return false;
    }

    public boolean isObfuscatingNames() {
        return false;
    }

    @Override
    protected void activateChannel(Channel chnl) {
        ProtocolBuffer b = ProtocolBuffer.getInstance();
        DataOutputStream str = b.addPayload();
        if (DebugFlags.CHANNELS.show()) {
            LogSupport.message((Object)this, (String)"activateChannel", (String)("Activating channel '" + chnl.getName() + "'"));
        }
        try {
            str.writeUTF(chnl.getName());
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"activateChannel", (Throwable)ex, (boolean)true);
        }
        this.fireOnMessage((short)0, (byte)1, b);
    }

    @Override
    protected void deactivateChannel(Channel chnl) {
        ProtocolBuffer b = ProtocolBuffer.getInstance();
        DataOutputStream str = b.addPayload();
        if (DebugFlags.CHANNELS.show()) {
            LogSupport.message((Object)this, (String)"deactivateChannel", (String)("Deactivating channel '" + chnl.getName() + "'"));
        }
        try {
            str.writeByte(chnl.getChannelID());
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"deactivateChannel", (Throwable)ex, (boolean)true);
        }
        this.fireOnMessage((short)0, (byte)3, b);
    }

    protected void fireOnMessage(short to, byte cmd, ProtocolBuffer b) {
        MessageEvent e = MessageEvent.getInstance((Object)this, this.getAddress(), to, this.getGroupID(), (byte)1, (byte)0, cmd, b);
        try {
            this.fireMessage(e);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireOnMessage", (Throwable)ex, (boolean)true);
        }
    }

    protected void fireOnMessage(short to, byte cmd) {
        this.fireOnMessage(to, cmd, ProtocolBuffer.getInstance());
    }

    @Override
    public void connectionStatusChanged(ConnectionEvent event) {
        switch (event.getAction()) {
            case 2: {
                if (!this.ncListeners.isEmpty()) {
                    this.setNewChannelNotify(true);
                }
                this.sessionTimeBase = System.currentTimeMillis();
                this.connectionOffset = 0L;
                break;
            }
            case 3: {
                this.deactivateAllChannels();
                if (this.connector != null && this.getGroupID() != 0) {
                    this.connector.setGroupID((short)0);
                    this.clientMgr.groupJoin((short)0, this.getAddress());
                }
                this.clientMgr.clientClear();
                this.clients.resetProperties();
            }
        }
        this.fireConnectionEvent(event);
    }

    protected boolean defaultMessageHandler(MessageEvent msg) {
        DataInputStream str = msg.read();
        boolean processed = true;
        if (!this.isConnected()) {
            try {
                str.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return true;
        }
        this.traceMessage("recv", msg);
        if (msg.getSourceAddress() != 0) {
            try {
                str.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return true;
        }
        block16 : switch (msg.getCommand()) {
            case 2: {
                try {
                    String cName = str.readUTF();
                    byte cID = str.readByte();
                    Channel chnl = this.findChannel(cName);
                    if (chnl == null) break;
                    try {
                        this.connector.addMessageListener(cID, chnl);
                        chnl.addMessageListener(this.connector);
                    }
                    catch (TooManyListenersException ex) {
                        LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                    }
                    chnl.getController().chnlUp(this.getAddress(), cID);
                    ProtocolBuffer buf = ProtocolBuffer.getInstance();
                    DataOutputStream wstr = buf.addPayload();
                    wstr.writeByte(cID);
                    wstr.close();
                    this.fireOnMessage((short)0, (byte)7, buf);
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                }
                break;
            }
            case 4: {
                try {
                    String cName = str.readUTF();
                    Channel chnl = this.findChannel(cName);
                    if (chnl == null) break;
                    chnl.getController().chnlAbort();
                    this.removeChannel(chnl);
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                }
                break;
            }
            case 6: {
                try {
                    int count = str.readByte();
                    for (int i = 0; i < count; ++i) {
                        String cName = str.readUTF();
                        this.fireNewChannelEvent(cName);
                    }
                    break;
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                    break;
                }
            }
            case 9: 
            case 10: {
                try {
                    byte id = str.readByte();
                    short count = str.readShort();
                    while (true) {
                        short s = count;
                        count = (short)(count - 1);
                        if (s <= 0) break block16;
                        short addr = str.readShort();
                        Channel chnl = this.findChannel(id);
                        if (chnl == null) continue;
                        if (msg.getCommand() == 9) {
                            chnl.getController().chnlJoin(addr);
                            continue;
                        }
                        chnl.getController().chnlLeave(addr);
                    }
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                    break;
                }
            }
            case 17: {
                try {
                    int count = str.readInt();
                    if (DebugFlags.CLIENTS.show()) {
                        LogSupport.message((Object)this, (String)"defaultMessageHandler", (String)("Adding " + count + " clients"));
                    }
                    for (int i = 0; i < count; ++i) {
                        String name = str.readUTF();
                        String disp = str.readUTF();
                        short addr = str.readShort();
                        short grp = str.readShort();
                        if (this.clients.get(addr) == null) {
                            this.clientMgr.clientAdd(name, disp, addr, grp);
                        }
                        if (addr != this.getAddress()) continue;
                        try {
                            this.activateAllChannels();
                            continue;
                        }
                        catch (JinxChannelException ex) {
                            LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)false);
                        }
                    }
                    break;
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                    break;
                }
            }
            case 18: {
                try {
                    short addr = str.readShort();
                    this.clientMgr.clientRemove(addr);
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                }
                break;
            }
            case 33: {
                while (this.decodePropertyDef(str)) {
                }
                break;
            }
            case 34: {
                short from = msg.getSourceAddress();
                while (this.decodeProperty(null, from, str)) {
                }
                break;
            }
            case 12: {
                break;
            }
            case 49: {
                try {
                    int count = str.readShort();
                    for (int i = 0; i < count; ++i) {
                        short id = str.readShort();
                        String name = str.readUTF();
                        boolean isTransient = str.readBoolean();
                        this.clientMgr.groupCreate(id, name, isTransient);
                    }
                    break;
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                    break;
                }
            }
            case 50: {
                try {
                    int count = str.readShort();
                    for (int i = 0; i < count; ++i) {
                        short id = str.readShort();
                        this.clientMgr.groupDelete(id);
                    }
                    break;
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                    break;
                }
            }
            case 51: {
                try {
                    short grp = str.readShort();
                    int count = str.readShort();
                    if (this.clients.getClientGroup(grp) == null) break;
                    for (int i = 0; i < count; ++i) {
                        short addr = str.readShort();
                        if (addr == this.getAddress()) {
                            this.connector.setGroupID(grp);
                        }
                        this.clientMgr.groupJoin(grp, addr);
                    }
                    break;
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
                    break;
                }
            }
            case 52: {
                try {
                    short grp = str.readShort();
                    String nm = str.readUTF();
                    this.clientMgr.groupRename(grp, nm);
                }
                catch (IOException iox) {
                    LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)iox, (boolean)true);
                }
                break;
            }
            case 65: {
                try {
                    long base = str.readLong();
                    long offset = str.readLong();
                    this.sessionTimeBase = base;
                    this.connectionOffset = offset - this.getConnectedMillis();
                }
                catch (IOException iox) {
                    LogSupport.exception((Object)this, (String)"defaultMessagehandler", (Throwable)iox, (boolean)true);
                }
                break;
            }
            default: {
                processed = false;
            }
        }
        try {
            if (str != null) {
                str.close();
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"defaultMessageHandler", (Throwable)ex, (boolean)true);
        }
        return processed;
    }

    @Override
    public void onMessage(MessageEvent msg) {
        if (!this.defaultMessageHandler(msg)) {
            LogSupport.error((Object)this, (String)"onMessage", (String)("Unhandled control message command '" + msg.getCommand() + "'"));
        }
    }

    @Override
    public void onTransmitStatus(TransmitStatusEvent event) {
        LogSupport.error((Object)this, (String)"onTransmitStatus", (String)"Unexpected transmit status event.");
    }

    @Override
    protected void setNewChannelNotify(boolean on) {
        ProtocolBuffer buf = ProtocolBuffer.getInstance();
        DataOutputStream str = buf.addPayload();
        try {
            str.writeBoolean(on);
            str.close();
            this.fireOnMessage((short)0, (byte)5, buf);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"setNewChannelNotify", (Throwable)ex, (boolean)true);
        }
    }
}

