/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.safari;

import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationStatusCode;
import com.teamdev.jxbrowser.events.ProgressChangedEvent;
import com.teamdev.jxbrowser.events.StatusChangedEvent;
import com.teamdev.jxbrowser.events.TitleChangedEvent;
import com.teamdev.jxbrowser.safari.PolicyDelegate;
import com.teamdev.jxbrowser.safari.SafariBrowser;
import com.teamdev.jxbrowser.webkit.event.BrowserEvent;
import com.teamdev.jxbrowser.webkit.event.BrowserListener;
import com.teamdev.jxbrowser.webkit.event.StatusCode;

class SafariEvents {
    private SafariBrowser browser;
    private String documentTitle;
    private boolean navigationFinished;

    public SafariEvents(SafariBrowser safariBrowser) {
        this.browser = safariBrowser;
        this.browser.getPeer().addBrowserListener(new SafariBrowserListener());
        this.browser.getPeer().setWebPolicyDelegate(new PolicyDelegate(this));
    }

    public SafariBrowser getBrowser() {
        return this.browser;
    }

    public boolean isNavigationFinished() {
        return this.navigationFinished;
    }

    boolean isReady() {
        return this.browser.getPeer().isReady();
    }

    public String getStatusMessage() {
        return "";
    }

    public String getTitle() {
        return this.documentTitle;
    }

    private NavigationStatusCode getNavigationStatusCode(StatusCode statusCode) {
        return new NavigationStatusCode(statusCode.getValue(), statusCode.getDescription());
    }

    public void setNavigationFinished(boolean bl) {
        this.navigationFinished = bl;
    }

    private class SafariBrowserListener
    implements BrowserListener {
        private SafariBrowserListener() {
        }

        public void onTitleChange(BrowserEvent browserEvent) {
            SafariEvents.this.documentTitle = browserEvent.getTitle();
            SafariEvents.this.browser.notifyListeners(new TitleChangedEvent((Browser)SafariEvents.this.browser, SafariEvents.this.documentTitle));
        }

        public void onStatusChange(BrowserEvent browserEvent) {
            SafariEvents.this.browser.notifyListeners(new StatusChangedEvent((Browser)SafariEvents.this.browser, browserEvent.getStatus()));
        }

        public void onDownloadBegin(BrowserEvent browserEvent) {
            SafariEvents.this.setNavigationFinished(false);
            SafariEvents.this.browser.notifyListeners(new NavigationEvent((Browser)SafariEvents.this.browser, browserEvent.getUrl()));
        }

        public void onDownloadComplete(BrowserEvent browserEvent) {
            SafariEvents.this.setNavigationFinished(true);
            SafariEvents.this.browser.notifyListeners(new NavigationFinishedEvent((Browser)SafariEvents.this.browser, SafariEvents.this.getNavigationStatusCode(browserEvent.getStatusCode()), browserEvent.getUrl()));
        }

        public void onNavigationErrorOccurred(BrowserEvent browserEvent) {
            SafariEvents.this.setNavigationFinished(true);
            SafariEvents.this.browser.notifyListeners(new NavigationFinishedEvent((Browser)SafariEvents.this.browser, SafariEvents.this.getNavigationStatusCode(browserEvent.getStatusCode()), browserEvent.getUrl()));
        }

        public void onProgressChanged(long l) {
            SafariEvents.this.browser.notifyListeners(new ProgressChangedEvent((Browser)SafariEvents.this.browser, l, 100L));
        }
    }
}

